#include <sioux.h>
#include <gusi.h>
#include <ICCAPI.h>
#include <ICAPI.h>
#include <TextUtils.h>

#include "MacInit.h"
#include "MacCore.h"
#include "MacDrag.h"
#include "HTString.h"
#include "MacSpeech.h"

ICInstance MacICinst;
int ICpresent = 0;

int macQuit = 0;
int macGotoURL = 0;
int macCmd = -1;
char * macCmdParam = NULL;
char * macCommand = NULL;

char **environ;

void InitEnviron()
{
	int i;
	
	environ = (char **) malloc (32 * sizeof (char *));
	for (i=0;i<32;i++)
		environ[0]=NULL;

}

void MacInit( )
{
   /* Starts Mac GUSI socket library */
//    GUSISetup(GUSIwithSIOUXSockets);
//    GUSISetup(GUSIwithInternetSockets);
    GUSIDefaultSetup();
	 MacMain();
//    SIOUXSettings.asktosaveonclose = false;
	 SIOUXSettings.setupmenus = false;
	 MaxApplZone();
	 TestForSpeechManager();
	 MacDragInit();
	 initIC();
	 InitEnviron();

}

void MacClose()
{
 	if (ICpresent == 1)
		    ICStop(MacICinst); 
   CloseSpeechManager();
   MacDragClose();
   cleanup();
	ExitToShell();
}



pascal int initIC()
{
  ICError err;
  
  err = ICStart(&MacICinst, 0);
  if (err == noErr)
  {
  		ICpresent=1;
      err = ICFindConfigFile(MacICinst, 0, nil);
  
  }
  	else 
  		ICpresent=0;
  
}


void launchURL(char * url)
{
	ICError err;

   if (ICpresent)
   {
   	long start = 0;
   	long end = 0;
   	err = ICLaunchURL(MacICinst, "\p",  url, strlen(url), &start,&end);
   	if (err != noErr)
  			SysBeep(1); 
	}
}

char * MacGetStringPref(ConstStr255Param key)
{
	ICError err;
	Str255 pref;
	long size;
	long attr;
	char* final = nil;

	if (ICpresent)
	{
		err = ICBegin(MacICinst, icReadOnlyPerm);
		size = sizeof(pref);
		err = ICGetPref(MacICinst, key, &attr, (Ptr) pref, &size);
		err = ICEnd(MacICinst);
	
		p2cstr(pref);
		final = (char*) malloc(strlen((char *)pref));
		strcpy(final,(char *)pref);
		return final;
	}
	else
		return nil;
}

int MacIsICPref(ConstStr255Param key)
{
	ICError err;
	Str255 pref;
	long size;
	long attr;

	if (ICpresent)
	{
		err = ICBegin(MacICinst, icReadOnlyPerm);
		size = sizeof(pref);
		err = ICGetPref(MacICinst, key, &attr, (Ptr) pref, &size);
		err = ICEnd(MacICinst);
	
		return (pref != nil);
	}
	else
		return 0;
}


